import pandas as pd
import pickle

atp_tennis = pd.read_csv('atp_tennis.csv')

# Count the number of wins for each player
player_wins = atp_tennis['Winner'].value_counts()
  
# Count the total number of matches played by each player
player_matches = atp_tennis['Player_1'].value_counts() + atp_tennis['Player_2'].value_counts()
  
# Calculate win/loss ratio for each player
win_loss_ratios = player_wins / (player_matches - player_wins)
  
# Add win/loss ratios to the dataset
atp_tennis['Win_Loss_Ratio_1'] = atp_tennis['Player_1'].map(win_loss_ratios)
atp_tennis['Win_Loss_Ratio_2'] = atp_tennis['Player_2'].map(win_loss_ratios)

# Combine Rank_1, Rank_2, Win_Loss_Ratio_1, and Win_Loss_Ratio_2 into single columns   
combined_ranks = pd.concat([atp_tennis['Rank_1'], atp_tennis['Rank_2']]).reset_index(drop=True)   
combined_win_loss_ratios = pd.concat([atp_tennis['Win_Loss_Ratio_1'], atp_tennis['Win_Loss_Ratio_2']]).reset_index(drop=True)   

# Create a DataFrame with combined ranks and win/loss ratios   
combined_data = pd.DataFrame({'Rank': combined_ranks, 'Win_Loss_Ratio': combined_win_loss_ratios})  

print(combined_data)
pickle.dump(combined_data,open("./ref_result/combined_data.pkl","wb"))